from pyparsing import Forward, Literal, OneOrMore, Word, printables, ZeroOrMore, alphanums, alphas, oneOf

curly_braces_block = Forward()
curly_braces_content = OneOrMore(Word(printables, excludeChars="{}"))
curly_braces_block << Literal("{") + ZeroOrMore(curly_braces_content | curly_braces_block) + Literal("}")
curly_braces_block.setParseAction(lambda location, tokens: [tokens[0], location])

round_braces_block = Forward()
round_braces_content = OneOrMore(Word(printables, excludeChars="()"))
round_braces_block << Literal("(") + ZeroOrMore(round_braces_content | round_braces_block) + Literal(")")
round_braces_block.setParseAction(lambda location, tokens: [tokens[0], location])

ID = Word(alphas + "_", alphanums + "_")
qualified_id = Word(alphas + "_", alphanums + "_.")

python_requests_call_pattern = Literal("requests") + Literal(".") + oneOf(
    "get put post delete head") + round_braces_block

double_quote_string_content = ZeroOrMore(Word(printables, excludeChars='"') | Literal('\\"'))
single_quote_string_content = ZeroOrMore(Word(printables, excludeChars="'"))
backtick_string_content = ZeroOrMore(Word(printables, excludeChars="`") | Literal("\\`"))

java_string = Literal('"') + double_quote_string_content + Literal('"')
python_string = java_string | (Literal("'") + single_quote_string_content + Literal("'"))
js_string = python_string | (Literal("`") + backtick_string_content + Literal("`"))

http_url_start = Literal("http://") | Literal("https://")
